﻿using Microscopic_Traffic_Simulator___Model.GeneralParameters;
using System;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.GeneralParameters
{
    /// <summary>
    /// Class containing all simulator parameters.
    /// </summary>
    [Serializable]
    public class Parameters
    {
        /// <summary>
        /// Reference to cellular topology parameters.
        /// </summary>
        private CellularTopologyParameters cellularTopologyParameters = new CellularTopologyParameters();
        /// <summary>
        /// Reference to cellular topology parameters.
        /// </summary>
        public CellularTopologyParameters CellularTopologyParameters { get { return cellularTopologyParameters; } }

        /// <summary>
        /// Reference to transition function parameters.
        /// </summary>
        private TransitionFunctionParameters transitionFunctionParameters = new TransitionFunctionParameters();
        /// <summary>
        /// Reference to transition function parameters.
        /// </summary>
        public TransitionFunctionParameters TransitionFunctionParameters
        {
            get { return transitionFunctionParameters; }
        }

        /// <summary>
        /// Opens parameters file to import.
        /// </summary>
        /// <param name="path">Path to file.</param>
        public static Parameters Deserialize(string path)
        {
            using (FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read,
                FileShare.Read))
            {
                return (Parameters)new BinaryFormatter().Deserialize(fs);
            }
        }

        /// <summary>
        /// Save parameters to file.
        /// </summary>
        /// <param name="path">Path to file.</param>
        public void Serialize(string path)
        {
            using (FileStream fs = new FileStream(path, FileMode.Create, FileAccess.Write,
                FileShare.None))
            {
                new BinaryFormatter().Serialize(fs, this);
            }
        }
    }
}
